/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file sound_manager.hpp
 * \brief A class to manage sound resources.
 * \author Julien Jorge
 */
#ifndef __AUDIO_SOUND_MANAGER_HPP__
#define __AUDIO_SOUND_MANAGER_HPP__

#include "audio/sound.hpp"
#include "audio/music.hpp"
#include <iostream>
#include <map>
#include <string>

#include "audio/class_export.hpp"

namespace bear
{
  namespace audio
  {
    /**
     * \brief A class to manage sound resources.
     * \author Julien Jorge
     */
    class AUDIO_EXPORT sound_manager
    {
    public:
      sound_manager();
      ~sound_manager();

      void clear();
      void load_sound( const std::string& name, std::istream& file );
      void load_music( const std::string& name, std::istream& file );

      sound& get_sound( const std::string& name );
      music& get_music( const std::string& name );

      void set_ears_position( const claw::math::coordinate_2d<int>& position );
      const claw::math::coordinate_2d<int>& get_ears_position() const;

      bool sound_exists( const std::string& name ) const;
      bool music_exists( const std::string& name ) const;

      void stop_all();

      static void initialize();
      static void release();

    private:
      /** \brief All sounds. */
      std::map<std::string, sound*> m_sounds;

      /** \brief All musics. */
      std::map<std::string, music*> m_musics;

      /** \brief Ears position. */
      claw::math::coordinate_2d<int> m_ears_position;

      /** \brief Tell if the sound system is initialized. */
      static bool s_initialized;

    }; // class sound_manager
  } // namespace audio
} // namespace bear

#endif // __AUDIO_SOUND_MANAGER_HPP__
