/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file level_border.tpp
 * \brief Implementation of the bear::engine::level_border class
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor. Apply the event for each zone around.
 */
template<typename Event>
bear::engine::level_border<Event>::level_border()
{
  this->set_mass(0);

  super::set_collision_event( universe::zone::top_left_zone, new Event );
  super::set_collision_event( universe::zone::top_zone, new Event );
  super::set_collision_event( universe::zone::top_right_zone, new Event );
  super::set_collision_event( universe::zone::middle_left_zone, new Event );
  //super::set_collision_event( universe::zone::middle_zone, new Event );
  super::set_collision_event( universe::zone::middle_right_zone, new Event );
  super::set_collision_event( universe::zone::bottom_left_zone, new Event );
  super::set_collision_event( universe::zone::bottom_zone, new Event );
  super::set_collision_event( universe::zone::bottom_right_zone, new Event );
} // level_border::level_border()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if the item is correctly initialized.
 */
template<typename Event>
bool bear::engine::level_border<Event>::is_valid() const
{
  return super::is_valid();
} // level_border::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set an integer field of the item.
 * \param name The name of the field.
 * \param value The integer to set.
 */
template<typename Event>
bool bear::engine::level_border<Event>::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool result = true;

  if ( name == "width" )
    this->set_width( value );
  else if ( name == "height" )
    this->set_height( value );
  else
    result = super::set_u_integer_field( name, value );

  return result;
} // level_border::set_u_integer_field()
