/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file core/engine/code/level_loader.tpp
 * \brief Implementation of the template methods of the
 *        bear::engine::level_loader class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Load a list of values.
 * \param v (out) The values read from the file.
 * \return The name of the corresponding field.
 */
template<typename T>
std::string bear::engine::level_loader::load_list( std::vector<T>& v )
{
  std::string field_name;
  unsigned int n;
  T val;

  m_file >> field_name >> n;

  v.resize(n);

  for (unsigned int i=0; i!=n; ++i)
    {
      m_file >> val;
      v[i] = val;
    }

  m_file >> m_next_code;

  return field_name;
} // level_loader::load_list()
