/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file with_animation.cpp
 * \brief Implementation of the bear::engine::with_animation class.
 * \author Sebastien Angibaud
 */
#include "engine/with_animation.hpp"
#include <claw/assert.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
bear::engine::with_animation::with_animation()
  : m_animation(NULL)
{

} // with_animation::with_animation()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bear::engine::with_animation::~with_animation()
{
  if (m_animation)
    delete m_animation;
} // with_animation::~with_animation()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the animation.
 */
const bear::visual::animation&
bear::engine::with_animation::get_animation() const
{
  CLAW_PRECOND(m_animation != NULL);

  return *m_animation;
} // with_animation::get_animation()
