/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_stop_player.tpp
 * \brief Implementation of the engine::collision_event_stop_player class.
 * \author Julien Jorge
 */
#include "engine/player.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Align the player and stop him horizontaly if he's on the left or
 *        on the right, or stop him verticaly if he's on the top or at the
 *        bottom.
 * \param info Informations on the collision.
 * \param self The other item in the collision.
 * \param that The item that should be the player.
 */
template<class Alignment>
void bear::engine::collision_event_stop_player<Alignment>::execute
( const universe::collision_info& info, universe::physical_item& self,
  universe::physical_item& that ) const
{
  if ( dynamic_cast<player*>(&that) )
    super::execute( info, self, that );
} // collision_event_stop_player::execute()
