/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_stop_player.hpp
 * \brief A collision event who align the player and stop him verticaly or
 *        horizontaly, regarding its new position.
 * \author Julien Jorge
 */
#ifndef __ENGINE_COLLISION_EVENT_STOP_PLAYER_HPP__
#define __ENGINE_COLLISION_EVENT_STOP_PLAYER_HPP__

#include "universe/collision_event/collision_event_align_stop.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A collision event who align the player and stop him verticaly or
     *        horizontaly, regarding its new position.
     */
    template<class Alignment>
    class collision_event_stop_player:
      public universe::collision_event_align_stop<Alignment>
    {
    private:
      typedef universe::collision_event_align_stop<Alignment> super;

    public:
      virtual void execute( const universe::collision_info& info,
                            universe::physical_item& self,
                            universe::physical_item& that ) const;

    }; // class collision_event_stop_player

    // define the collision_event_stop_player_type class
    DEFINE_ALIGN_EVENT_TYPE( collision_event_stop_player );

    typedef
    universe::align_event_generator<collision_event_stop_player_type>
    event_generator_stop_player;

  } // namespace engine
} // namespace bear

#include "engine/collision_event/code/collision_event_stop_player.tpp"

#endif // __ENGINE_COLLISION_EVENT_STOP_PLAYER_HPP__
