/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_local_to_network_reader.hpp
 * \brief Input reader for network game. Read the inputs of the local player
 *        and send them to a distant game.
 * \author Julien Jorge
 */
#ifndef __ENGINE_INPUT_LOCAL_TO_NETWORK_READER_HPP__
#define __ENGINE_INPUT_LOCAL_TO_NETWORK_READER_HPP__

#include "engine/input_reader/input_base_local_reader.hpp"

#include <claw/osocket_stream.hpp>

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Input reader for network game. Read the inputs of the local player
     *        and send them to a distant game.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT input_local_to_network_reader : public input_base_local_reader
    {
    public:
      input_local_to_network_reader( unsigned int player_index,
                                     const controller_layout& layout,
                                     const std::string& address, int port );

    private:
      virtual void send_start_action_to_player( player::action action );
      virtual void send_stop_action_to_player( player::action action );
      virtual void send_action_to_player( player::action action );

    private:
      /** \brief The socket on which we write the inputs. */
      claw::net::osocket_stream m_output;

    }; // class input_local_to_network_reader
  } // namespace engine
} // namespace bear

#endif // __ENGINE_INPUT_LOCAL_TO_NETWORK_READER_HPP__
