/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file input_reader.hpp
 * \brief Base class for input readers.
 *
 * Input readers are classes that read inputs and pass the corresponding actions
 * to the concerned player.
 *
 * \author Julien Jorge
 */
#ifndef __ENGINE_INPUT_READER_HPP__
#define __ENGINE_INPUT_READER_HPP__

#include "engine/pointer_to_player.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Base class for input readers.
     *
     * Input readers are classes that read inputs and pass the corresponding
     * actions to the concerned player.
     *
     * \author Julien Jorge
     */
    class ENGINE_EXPORT input_reader
    {
    public:
      input_reader( unsigned int player_index );
      virtual ~input_reader();

      void update();

    protected:
      virtual void read_and_apply() = 0;

    protected:
      /** \brief Pointer to the controlled player. */
      pointer_to_player m_player;

    }; // class input_reader
  } // namespace engine
} // namespace bear

#endif // __ENGINE_INPUT_READER_HPP__
