/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file pointer_to_player.hpp
 * \brief A pointer to a player that find the new instance of the player if he
 *        died since last use.
 * \author Julien Jorge
 */
#ifndef __ENGINE_POINTER_TO_PLAYER_HPP__
#define __ENGINE_POINTER_TO_PLAYER_HPP__

#include "engine/class_export.hpp"

#include "engine/player.hpp"
#include "engine/item_handle.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief A pointer to a player that find the new instance of the player if
     *        he died since last use.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT pointer_to_player
    {
    public:
      pointer_to_player( const std::string& player_name = "" );
      pointer_to_player( player* item );

      bool is_valid();
      player* get();

      operator bool();
      operator bool() const;
      operator player*();

      player* operator->();
      const player* operator->() const;
      pointer_to_player& operator=( player* item );

    private:
      void find_player_instance();

    private:
      /** \brief The name of the player we are pointing to. */
      std::string m_player_name;

      /** \brief Handle to the player. */
      item_handle m_player;

    }; // class pointer_to_player
  } // namespace engine
} // namespace bear

#endif // __ENGINE_POINTER_TO_PLAYER_HPP__
