/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file with_decoration.hpp
 * \brief Inherit from this item to have a sprite or an animation.
 * \author Sebastien Angibaud
 */
#ifndef __ENGINE_WITH_DECORATION_HPP__
#define __ENGINE_WITH_DECORATION_HPP__

#include "engine/basic_renderable_item.hpp"
#include "engine/class_export.hpp"
#include "engine/with_sprite.hpp"
#include "engine/with_animation.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Inherit from this item to have a sprite or an animation.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT with_decoration
      : public with_sprite,
	public with_animation
    {
    }; // class with_decoration
  } // namespace engine
} // namespace bear

#endif // __ENGINE_WITH_DECORATION_HPP__
