/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file mouse.hpp
 * \brief A class representing a mouse.
 * \author Julien Jorge
 */
#ifndef __INPUT_MOUSE_HPP__
#define __INPUT_MOUSE_HPP__

#include <string>
#include <vector>
#include <list>

#include <claw/math.hpp>
#include <SDL/SDL.h>

#include "input/class_export.hpp"

namespace bear
{
  namespace input
  {
    /**
     * \brief A class representing a mouse.
     */
    class INPUT_EXPORT mouse
    {
    public:
      /** \brief Code representing a button on the mouse. */
      typedef unsigned char mouse_code;

      /** \brief Iterator on the pressed buttons. */
      typedef std::list<mouse_code>::const_iterator const_iterator;

    public:
      mouse();

      static const std::string& get_name_of( mouse_code b );
      static void set_name_of( mouse_code k, const std::string& s );

      const_iterator begin() const;
      const_iterator end() const;
      bool empty() const;

      const claw::math::coordinate_2d<unsigned int>& get_position() const;

      // only for input::system
      void refresh();

    public:
#include "input/mouse_codes.hpp"

    private:
      mouse_code sdl_button_to_local( unsigned int sdl_val ) const;

      void default_mouse_code_strings();

    private:
      /** \brief Pressed buttons. */
      std::list<mouse_code> m_pressed_buttons;

      /** \brief Human-readable names for each joy_code. */
      static std::vector<std::string> s_button_strings;

      /** \brief Position of the cursor. */
      claw::math::coordinate_2d<unsigned int> m_position;

    }; // class mouse
  } // namespace input
} // namespace bear

#endif // __INPUT_MOUSE_HPP__
