/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file converion.hpp
 * \brief Implementation of the bear::text::convertible class
 * \author Julien Jorge
 */
#include "text/conversion.hpp"
#include <sstream>

/*----------------------------------------------------------------------------*/
/**
 * \brief Output a bear::text::convertible as a string.
 * \param os The stream in which we write.
 * \param that The item to write.
 */
std::ostream&
operator<<( std::ostream& os, const bear::text::convertible& that )
{
  std::string str;

  that.to_string( str );
  return os << str;
} // operator<<()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bear::text::convertible::~convertible()
{
  // nothing to do
} // convertible::~convertible()

/*----------------------------------------------------------------------------*/
/**
 * \brief Convert the item into a string.
 * \param result The result of the conversion.
 */
void bear::text::convertible::to_string( std::string& result ) const
{
  std::ostringstream oss;

  oss << "0x" << std::hex << this;
  result = oss.str();
} // convertible::to_string()
