/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file base_entity.cpp
 * \brief Implementation of the bear::universe::base_entity class.
 * \author Julien Jorge
 */
#include "universe/base_entity.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
bear::universe::base_entity::base_entity()
  : m_is_global(false)
{

} // base_entity::base_entity()

/*----------------------------------------------------------------------------*/
/**
 * \brief Copy contructor.
 */
bear::universe::base_entity::base_entity( const base_entity& that )
  : m_is_global(that.m_is_global)
{

} // base_entity::base_entity()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void bear::universe::base_entity::progress( time_type elapsed_time )
{
  // nothing to do
} // base_entity::progress()

/*---------------------------------------------------------------------------*/
/**
 * \brief Inform the item tat he left the active region.
 */
void bear::universe::base_entity::left_active_region()
{
  // nothing to do
} // base_entity::left_active_region()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the global status.
 */
bool bear::universe::base_entity::is_global() const
{
  return m_is_global;
} // base_entity::is_global()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set if the item is global.
 * \param global The new global status.
 */
void bear::universe::base_entity::set_global( bool global )
{
  m_is_global = global;
} // base_entity::set_global()
