/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_translation.cpp
 * \brief Implementation of the bear::universe::forced_translation class.
 * \author Sbastien Angibaud
 */
#include "universe/forced_translation.hpp"

/*---------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param moving_item The item to wich to movement is applied.
 * \param speed The speed of the item.
 */
bear::universe::forced_translation::forced_translation
( physical_item& moving_item, speed_type speed )
  : forced_movement(moving_item), m_speed(speed)
{
} // forced_translation::forced_translation() [constructor]

/*---------------------------------------------------------------------------*/
/**
 * \brief Start the movement.
 */
void bear::universe::forced_translation::start()
{

} // forced_translation::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do an iteration of the movement.
 */
void bear::universe::forced_translation::next_position()
{
  position_type new_position;
  new_position.x = m_moving_item.get_position().x + m_speed.x;
  new_position.y = m_moving_item.get_position().y + m_speed.y;

  m_moving_item.set_position(new_position);
} // forced_translation::next_position()

/*---------------------------------------------------------------------------*/
/**
 * \brief Stop the movement.
 */
void bear::universe::forced_translation::stop()
{

} // forced_translation::stop()
