/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file align_share_speed.hpp
 * \brief This collision event aligns the other item and sets the acceleration
 *        of the to the two items equal to their sum.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_ALIGN_SHARE_SPEED_HPP__
#define __UNIVERSE_ALIGN_SHARE_SPEED_HPP__

#include "universe/collision_event/collision_event_align.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief This collision event aligns the other item and sets the
     *        acceleration of the to the two items equal to their sum.
     * \author Julien Jorge
     */
    template<class Alignment>
    class align_share_speed :
      public collision_event_align<Alignment>
    {
    private:
      /** \brief The type of the parent class. */
      typedef collision_event_align<Alignment> super;

    public:
      void execute( const collision_info& info, physical_item& self,
                    physical_item& that ) const;

    }; // class align_share_speed

    // define the align_share_speed_type class
    DEFINE_ALIGN_EVENT_TYPE( align_share_speed );

    typedef
    align_event_generator<align_share_speed_type>
    event_generator_align_share_speed;

  } // namespace universe
} // namespace bear

#include "universe/collision_event/code/align_share_speed.tpp"

#endif // __UNIVERSE_ALIGN_SHARE_SPEED_HPP__
