/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file align_share_speed.tpp
 * \brief Implementation of the bear::universe::align_share_speed class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Align the other item and set the speed of each item equal to the
 *        average of the sum of their speeds.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The item to align.
 */
template<class Alignment>
void bear::universe::align_share_speed<Alignment>::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  super::execute( info, self, that );

  if( !that.is_phantom() )
    {
      claw::math::vector_2d<float> speed =
	(self.get_speed() + that.get_speed()) / 2;

      self.set_speed( speed );
      that.set_speed( speed );
    }
} // align_share_speed::execute()
