/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_align_accelerate.hpp
 * \brief A collision event who align the other item and accelerate it
 *        verticaly or horizontaly, regarding its new position.
 * \author Sebastien Angibaud
 */
#ifndef __UNIVERSE_COLLISION_EVENT_ALIGN_ACCELERATE_HPP__
#define __UNIVERSE_COLLISION_EVENT_ALIGN_ACCELERATE_HPP__

#include "universe/collision_event/collision_event_align.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A collision event who align the other item and accelerate it
     *        verticaly or horizontaly, regarding its new position.
     */
    template<class Alignment>
    class collision_event_align_accelerate
      : public collision_event_align<Alignment>
    {
    private:
      typedef collision_event_align<Alignment> super;

    public:
      collision_event_align_accelerate
      ( const speed_type& speed, const force_type& acceleration );

      virtual void execute( const collision_info& info, physical_item& self,
                            physical_item& that ) const;

    private:
      speed_type m_speed;
      force_type m_acceleration;

    }; // class collision_event_align_accelerate

    /**
     * \brief A class to help generating the
     *        collision_event_align_accelerate<Alignment> instance, where
     *        \a Alignment is generated from a universe::zone value.
     */
    class collision_event_align_accelerate_type
    {
    public:
      template<zone::position Z>
      class type :
        public collision_event_align_accelerate<typename align<Z>::type>
      {
      private:
        /** \brief The type of the parent class. */
        typedef collision_event_align_accelerate<typename align<Z>::type> super;

      public:
        /**
         * \brief Constructor.
         * \remark Just pass the parameters to the parent class.
         */
        type( const speed_type& speed, const force_type& acceleration )
          : super( speed, acceleration )
        { }
      }; // class type
    }; // class collision_event_align_accelerate_type

  } // namespace universe
} // namespace bear

#include "universe/collision_event/code/collision_event_align_accelerate.tpp"

#endif // __UNIVERSE_COLLISION_EVENT_ALIGN_ACCELERATE_HPP__
