/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file horizontal_nearest_align_stop.hpp
 * \brief A collision event for the middle zone. The other item is aligned with
 *        the left or the right edge, according to the one he is nearer to.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_HORIZONTAL_NEAREST_ALIGN_STOP_HPP__
#define __UNIVERSE_HORIZONTAL_NEAREST_ALIGN_STOP_HPP__

#include "universe/collision_event/collision_event.hpp"

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A collision event for the middle zone. The other item is aligned
     *        with the left or the right edge, according to the one he is nearer
     *        to.
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT horizontal_nearest_align_stop:
      public collision_event
    {
    public:
      horizontal_nearest_align_stop( bool left = true, bool right = true );
      ~horizontal_nearest_align_stop();

      virtual void execute( const collision_info& info, physical_item& self,
                            physical_item& that ) const;

    private:
      /** \brief Alignment applied when the other item is near our left edge. */
      collision_event* m_align_left;

      /** \brief Alignment applied when the other item is near our right
          edge. */
      collision_event* m_align_right;

    }; // class horizontal_nearest_align_stop
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_HORIZONTAL_NEAREST_ALIGN_STOP_HPP__
