/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file rigid_link.hpp
 * \brief This class is an elastic link between two items.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_RIGID_LINK_HPP__
#define __UNIVERSE_RIGID_LINK_HPP__

#include "universe/link/base_link.hpp"

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief This class is a rigid link between two items.
     *
     * A rigid_link force the second item to stay at a given distance (vector)
     * from the first item.
     *
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT rigid_link : public base_link
    {
    public:
      rigid_link( physical_item& first_item, physical_item& second_item );

      virtual void adjust();

    private:
      /** \brief The distance between the two items. */
      const universe::position_type m_distance;

    }; // class rigid_link
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_RIGID_LINK_HPP__
