/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file blur_effect.hpp
 * \brief Do a blur effect on an image.
 * \author Julien Jorge
 */
#ifndef __VISUAL_BLUR_EFFECT_HPP__
#define __VISUAL_BLUR_EFFECT_HPP__

#include "visual/screen_effect.hpp"

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Do a blur effect on an image.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT blur_effect: public screen_effect
    {
    public:
      virtual void apply();

    private:

    private:
      /** \brief The matrix applied to the image. */
      static const unsigned int s_size;
      /** \brief Divider. */
      static const unsigned int s_divider;
    }; // class blur_effect

  } // namespace visual
} // namespace bear

#endif // __VISUAL_BLUR_EFFECT_HPP__
