/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file blur_effect.cpp
 * \brief Implementation of the blur effect class
 * \author Julien Jorge
 */
#include "visual/blur_effect.hpp"
#include <claw/exception.hpp>
#include <GL/gl.h>

/*---------------------------------------------------------------------------*/
const unsigned int bear::visual::blur_effect::s_size = 5;

/*---------------------------------------------------------------------------*/
const unsigned int bear::visual::blur_effect::s_divider = 25;

/*---------------------------------------------------------------------------*/
/**
 * \brief Apply the filter to an image.
 */
void bear::visual::blur_effect::apply()
{
  const GLdouble val = 1.0 / 9.0;

  GLdouble filter[3][3] =
    {
      { val, val, val },
      { val, 1.0, val },
      { val, val, val }
    };

  glConvolutionFilter2D( GL_CONVOLUTION_2D, GL_RGBA, 3, 3, GL_LUMINANCE,
                         GL_FLOAT, filter );

  glEnable(GL_CONVOLUTION_2D);
  if ( glGetError() != GL_NO_ERROR)
    throw CLAW_EXCEPTION( "OpenGL error" );
} // blur_effect::apply()

