/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file progressive_screen_effect.cpp
 * \brief Implementation of the progressive_screen_effect class.
 * \author Julien Jorge.
 */

#include "visual/progressive_screen_effect.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param first_value The initial filter coefficient.
 * \param last_value The last filter coefficient.
 * \param length The length of the effect (how many iterations).
 */
bear::visual::progressive_screen_effect::progressive_screen_effect
( double first_value, double last_value, unsigned int length )
  : m_first_value(first_value), m_last_value(last_value),
    m_increment( (m_last_value - m_first_value) / (double)length )
{
  m_coeff = m_first_value;
} // progressive_screen_effect::progressive_screen_effect() [constructor]

/*----------------------------------------------------------------------------*/
/**
 * \brief Apply the filter to an image, with the current coefficient.
 * \param target The image to process.
 */
void
bear::visual::progressive_screen_effect::apply( claw::graphic::image& target )
{
  progressive_apply(target, m_coeff);

  if ( (m_increment > 0) && (m_coeff < m_last_value)
       || (m_increment < 0) && (m_coeff > m_last_value) )
    {
      m_coeff += m_increment;

      if ( (m_coeff > m_last_value) && (m_first_value < m_last_value) )
        m_coeff = m_last_value;
      else if ( (m_coeff < m_last_value) && (m_first_value > m_last_value) )
        m_coeff = m_last_value;
    }
} // progressive_screen_effect::apply()
