/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file image.hpp
 * \brief An image class, used for sprites.
 * \author Julien Jorge
 */
#ifndef __VISUAL_IMAGE_HPP__
#define __VISUAL_IMAGE_HPP__

#include <GL/gl.h>
#include <string>

#include <claw/pixel.hpp>
#include <claw/image.hpp>
#include <claw/math.hpp>

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief An image class, used for sprites.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT image
    {
    public:
      image( const claw::graphic::image& data );
      image( const image& that );

      ~image();

      GLuint texture_id() const;
      unsigned int width() const;
      unsigned int height() const;
      const claw::math::coordinate_2d<unsigned int>& size() const;

      image& operator=( const image& that );

    private:
      void create_texture( unsigned int width, unsigned int height );
      void copy_scanlines( const claw::graphic::image& pixels );

      void register_texture() const;
      void release_texture();

    private:
      /** \brief OpenGL texture identifier. */
      GLuint m_texture_id;

      /** \brief Image's size. */
      claw::math::coordinate_2d<unsigned int> m_size;

      /** \brief Number of instances using this texture. */
      static std::vector<unsigned int> s_texture_references;

    }; // class image

  } // namespace visual
} // namespace bear

#endif // __VISUAL_IMAGE_HPP__
