/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file pixel_effect.hpp
 * \brief Pixelize an image.
 * \author Julien Jorge
 */
#ifndef __VISUAL_PIXEL_EFFECT_HPP__
#define __VISUAL_PIXEL_EFFECT_HPP__

#include "visual/progressive_screen_effect.hpp"

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Pixelize an image.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT pixel_effect: public progressive_screen_effect
    {
    public:
      pixel_effect( double first_value, double last_value, unsigned int length);

    protected:
      virtual void progressive_apply( claw::graphic::image& target,
                                      double coeff );

    private:
      claw::graphic::pixel32
      average_pixel( const claw::graphic::image& reference,
                     const claw::math::rectangle<unsigned int>& area ) const;

      void fill_area( claw::graphic::image& target,
                      const claw::math::rectangle<unsigned int>& area,
                      const claw::graphic::pixel32& color ) const;
    }; // class pixel_effect

  } // namespace visual
} // namespace bear

#endif // __VISUAL_PIXEL_EFFECT_HPP__
