/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file screen_effect.hpp
 * \brief Base class for visual effects on the screen.
 * \author Julien Jorge.
 */
#ifndef __VISUAL_SCREEN_EFFECT_HPP__
#define __VISUAL_SCREEN_EFFECT_HPP__

#include <claw/image.hpp>

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Base class for visual effects on the screen.
     * \author Julien Jorge.
     */
    class VISUAL_EXPORT screen_effect
    {
    public:
      /**
       * \brief Destructor.
       */
      virtual ~screen_effect() {}

      /**
       * \brief Apply the filter to an image.
       */
      virtual void apply() = 0;
    }; // class screen_effect
  } // namespace visual
} // namespace bear

#endif // __VISUAL_SCREEN_EFFECT_HPP__
