/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file sprite.hpp
 * \brief A class to represent sprites.
 * \author Julien Jorge
 */
#ifndef __VISUAL_SPRITE_HPP__
#define __VISUAL_SPRITE_HPP__

#include "visual/image.hpp"
#include "visual/image_manager.hpp"
#include <claw/math.hpp>

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief A class to represent sprites.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT sprite
    {
    public:
      sprite( const image& img,
              const claw::math::rectangle<unsigned int>& clip_rectangle );
      sprite( const image& img );
      sprite( const sprite& spr); 
      //void get_mask ( mask& m );

      double get_alpha_blend() const;
      void  set_alpha_blend( double alpha_blend );

      const claw::math::rectangle<unsigned int>& clip_rectangle() const;
      const image& get_image() const;
      const claw::math::coordinate_2d<unsigned int>& get_size() const;

      void set_size( const claw::math::coordinate_2d<unsigned int>& s );
      void set_size( unsigned int w, unsigned int h );
      void set_width( unsigned int w );
      void set_height( unsigned int h );

      unsigned int width() const;
      unsigned int height() const;

      void flip( bool b );
      void mirror( bool b );

      bool is_flipped() const;
      bool is_mirrored() const;

    private:
      /** \brief The picture where we take the sprite. */
      const image m_image;

      /** \brief The sprite is this part of the image. */
      const claw::math::rectangle<unsigned int> m_clip_rectangle;

      /** \brief The size of the sprite on the screen. */
      claw::math::coordinate_2d<unsigned int> m_size;

      /** \brief Is the sprite reversed along Y axis ? */
      bool m_flip;

      /** \brief Is the sprite reversed along X axis ? */
      bool m_mirror;

      /** \brief Pixel intensity. */
      double m_alpha_blend;

    }; // class sprite

  } // namespace visual
} // namespace bear

#endif // __VISUAL_SPRITE_HPP__
