/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file change_friction_item.hpp.hpp
 * \brief The class describing a item which change the friction.hpp.
 * \author Sbastien Angibaud
 */
#ifndef __BEAR_CHANGE_FRICTION_ITEM_HPP__
#define __BEAR_CHANGE_FRICTION_ITEM_HPP__

#include "engine/base_item.hpp"

namespace bear
{
  /**
   * \brief The class describing a object which change the friction.
   * \author Sbastien Angibaud
   * The custom fields of this class are :
   *  - \a top_friction: \c Friction on the top,
   *  - \a bottom_friction: \c Friction on the bottom,
   *  - \a top_animation: \c Animation when an item throws on the top,
   *  - \a bottom_animation: \c Animation when an item throws on the bottom.
   */
  class change_friction_item:
    public engine::base_item
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    change_friction_item();
    ~change_friction_item();

    bool set_real_field( const std::string& name, double value );
    bool set_animation_field( const std::string& name, 
                              visual::animation* value );
    virtual void hit( engine::base_item& that,
		      const state_type& old_self,
		      const state_type& old_that );

  private:
    void create_animation
    ( visual::animation* anim, universe::position_type pos );


  private:
    /** \brief Friction on the top of the item. */
    double m_top_friction;

    /** \brief Friction on the bottm of the item. */
    double m_bottom_friction;

    /** \brief The animation when an item was on the top. */
    visual::animation* m_top_animation;

    /** \brief The animation when an item was on the bottom. */
    visual::animation* m_bottom_animation;

  }; // class change_friction_item
} // namespace bear

#endif // __BEAR_CHANGE_FRICTION_ITEM_HPP__
