/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file decorative_item.cpp
 * \brief Implementation of the bear::decorative_item class.
 * \author Sebastie Angibaud
 */
#include "generic_items/decorative_item.hpp"
#include "engine/export.hpp"

BASE_ITEM_EXPORT( decorative_item, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bear::decorative_item::decorative_item()
  : m_kill_when_finished(false)
{
  set_phantom(true);
  set_can_move_items(false);
} // decorative_item::decorative_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c <real>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool bear::decorative_item::set_real_field
( const std::string& name, double value )
{
  bool ok = true;

  if (name == "height")
    {
      set_height(value);
      if ( m_sprite != NULL ) 
        m_sprite->set_height((unsigned int)value);
    }
  else if (name == "width")
     {
      set_width(value);
      if ( m_sprite != NULL ) 
        m_sprite->set_width((unsigned int)value);
    }
  else
    ok = super::set_real_field(name,value);

  return ok;
} // decorative_item::set_real_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c bool.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool
bear::decorative_item::set_bool_field( const std::string& name, bool value )
{
  bool ok = true;

  if (name == "kill_when_finished")
    m_kill_when_finished = value;
  else 
    ok = super::set_bool_field(name, value);

  return ok;
} // decorative_item::set_bool_field()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 */
void
bear::decorative_item::progress( universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  if ( m_kill_when_finished ) 
    if ( m_animation != NULL )
      if ( get_animation().is_finished() )
	kill();
} // decorative_item::progress()
