/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file delayed_level_loading.cpp
 * \brief Implementation of the bear::delayed_level_loading class.
 * \author Julien Jorge
 */
#include "generic_items/delayed_level_loading.hpp"

#include "engine/export.hpp"
#include "engine/game.hpp"

BASE_ITEM_EXPORT( delayed_level_loading, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bear::delayed_level_loading::delayed_level_loading()
  : m_delay(1000)
{
  set_mass(0);
} // delayed_level_loading::delayed_level_loading()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <unsigned integer>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool bear::delayed_level_loading::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool result;

  if ( name == "delay" )
    {
      m_delay = value;
      result = true;
    }
  else
    result = super::set_u_integer_field( name, value );

  return result;
} // delayed_level_loading::set_u_integer_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <std::string>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool bear::delayed_level_loading::set_string_field
( const std::string& name, const std::string& value )
{
  bool result;

  if ( name == "level" )
    {
      m_level_name = value;
      result = true;
    }
  else
    result = super::set_string_field( name, value );

  return result;
} // delayed_level_loading::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if the item is correctly initialized.
 */
bool bear::delayed_level_loading::is_valid() const
{
  return !m_level_name.empty() && super::is_valid();
} // delayed_level_loading::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the current time
 */
void bear::delayed_level_loading::start()
{
  m_initial_time.set();
} // delayed_level_loading::start()

/*----------------------------------------------------------------------------*/
/**
 * \brief Start the level.
 */
void bear::delayed_level_loading::progress( universe::time_type elapsed_time )
{
  time_ref::time_reference now;

  now.set();

  if ( now - m_initial_time > m_delay )
    engine::game::get_instance().set_waiting_level( m_level_name );
} // delayed_level_loading::progress()
