/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file static_decorative_item.hpp
 * \brief A decorative sprite.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_DECORATIVE_ITEM_HPP__
#define __BEAR_DECORATIVE_ITEM_HPP__

#include "engine/base_item.hpp"
#include "engine/item_with_decoration.hpp"

#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief A decorative sprite.
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT decorative_item:
    public engine::item_with_decoration<engine::base_item>
  {
    /** \brief The type of the parent class. */
    typedef engine::item_with_decoration<engine::base_item> super;
  
  public:
    decorative_item();

    void progress( universe::time_type elapsed_time );
    
    bool set_real_field( const std::string& name, double value );
    bool set_bool_field( const std::string& name, bool value );

  private:
    /* \brief Indicates if the item kill itself when the animation is
       finished. */
    bool m_kill_when_finished;

  }; // class decorative_item
} // namespace bear

#endif // __BEAR_DECORATIVE_ITEM_HPP__
