/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file delayed_level_loading.hpp
 * \brief This class starts a level after a given delay.
 * \author Julien Jorge
 */
#ifndef __BEAR_DELAYED_LEVEL_LOADING_HPP__
#define __BEAR_DELAYED_LEVEL_LOADING_HPP__

#include "engine/base_item.hpp"
#include "time/time_reference.hpp"

namespace bear
{
  /**
   * \brief This class starts a level after a given delay.
   *
   * The custom fields of this class are :
   * - delay : integer, number of milliseconds of delay,
   * - level : string, name of the level to start.
   *
   * \author Julien Jorge
   */
  class delayed_level_loading : public engine::base_item
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    delayed_level_loading();

    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_string_field( const std::string& name, const std::string& value );
    bool is_valid() const;

    void start();
    void progress( universe::time_type elapsed_time );

  private:
    /** \brief Number of milliseconds of delay. */
    unsigned int m_delay;

    /** \brief The name of the level to load. */
    std::string m_level_name;

    /** \brief Date of the creation of the item. */
    time_ref::time_reference m_initial_time;

  }; // class delayed_level_loading
} // namespace bear

#endif // __BEAR_DELAYED_LEVEL_LOADING_HPP__
