/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file invisible_block.hpp
 * \brief A class representing a invisible block.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_INVISIBLE_BLOCK_HPP__
#define __BEAR_INVISIBLE_BLOCK_HPP__

#include "generic_items/base_invisible_block.hpp"
#include "universe/collision_event/collision_event_align_stop.hpp"

namespace bear
{
  /**
   * \brief A class representing a invisible block.
   * \author Sebastien Angibaud
   */
  typedef
  base_invisible_block<universe::event_generator_align_stop> invisible_block;
} // namespace bear

#endif // __BEAR_INVISIBLE_BLOCK_HPP__
