/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file decoration_layer.hpp
 * \brief A decoration layer contains animation and sprites positioned in the
 *        world.
 * \author Julien Jorge
 */
#ifndef __BEAR_DECORATION_LAYER_HPP__
#define __BEAR_DECORATION_LAYER_HPP__

#include "visual/screen.hpp"
#include "concept/static_map.hpp"
#include "engine/layer/layer.hpp"
#include "engine/base_item.hpp"
#include <claw/non_copyable.hpp>
#include <claw/math.hpp>

#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief A decoration layer contains animation and sprites positioned in
   *        the world.
   */
  class decoration_layer:
    public engine::layer
  {
  private:
    /**
     * \brief Common traits for the animation and the sprite items in the
     *        static_map.
     */
    class item_traits
    {
    public:
      claw::math::rectangle<unsigned int>
      get_bounding_box( engine::base_item* const& item ) const;
    }; // class item_traits

  public:
    decoration_layer( const universe::size_box_type& size );
    virtual ~decoration_layer();

    void add_item( engine::base_item& item );

    void start();

    void progress
    ( const region_type& active_area, universe::time_type elapsed_time  );

    void get_visual( std::list<engine::scene_visual>& visuals,
                     const universe::rectangle_type& visible_area ) const;

    void log_statistics() const;

  private:
    /** \brief All the animations. */
    concept::static_map<engine::base_item*, item_traits > m_items;

  }; // class decoration_layer
} // namespace bear

#endif // __BEAR_DECORATION_LAYER_HPP__
