/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file timer_item.hpp.hpp
 * \brief The class describing a timer item.
 * \author Sbastien Angibaud
 */
#ifndef __BEAR_TIMER_ITEM_HPP__
#define __BEAR_TIMER_ITEM_HPP__

#include "engine/base_item.hpp"
#include "engine/pointer_to_player.hpp"

#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief The class describing a timer object.
   * \author Sbastien Angibaud
   * The custom fields of this class are :
   *  - \a name: \c The name of the item,
   *  - \a countdown: \c Indicates if the timer is a countdown,
   *  - \a time: \c The initial time.
   */
  class GENERIC_ITEMS_EXPORT timer_item:
    public engine::messageable_item<engine::base_item>
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::messageable_item<engine::base_item> super;

    /*----------------------------------------------------------------------*/
    /**
     * \brief A message to get the value of the timer.
     * \author Julien Jorge
     */
    class GENERIC_ITEMS_EXPORT msg_get_value:
      public communication::message
    {
    public:
      bool apply_to( communication::messageable& that );
      
    public:
      /** \brief The value of the timer. */
      universe::time_type value;

    }; // class msg_get_value()

  public:
    timer_item();

    void start();
    void progress( universe::time_type elapsed_time );
    
    bool set_bool_field( const std::string& name, bool value );
    bool set_u_integer_field( const std::string& name, unsigned int value );

    bool is_valid() const;

    universe::time_type get_time() const;

  private:    
    /** \brief Pointer to the first player. */
    engine::pointer_to_player m_first_player;

    /** \brief Pointer to the second player. */
    engine::pointer_to_player m_second_player;

    /** \brief The real time. */
    universe::time_type m_time;

    /** \brief The save of the time at the beginning. */
    universe::time_type m_save_time;

    /** \brief Indicates if the timer is a countdown. */
    bool m_countdown;

  }; // class timer_item
} // namespace bear

#endif // __BEAR_TIMER_ITEM_HPP__
