/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/code/item_reference_edit.cpp
 * \brief Implementation of the bf::item_reference_edit class.
 * \author Julien Jorge
 */
#include "bf/item_reference_edit.hpp"

#include <claw/assert.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param parent The windows owning this one.
 * \param choices The valid choices of the value.
 * \param v The initial value.
 */
bf::item_reference_edit::item_reference_edit
( wxWindow& parent, const wxArrayString& choices, const value_type& v )
  : simple_edit<item_reference_type>(v),
    wxComboBox( &parent, wxID_ANY, wxEmptyString, wxDefaultPosition,
                wxDefaultSize, choices )
{
  value_updated();
} // item_reference_edit::item_reference_edit()

/*----------------------------------------------------------------------------*/
/**
 * \brief Check if the displayed value is correct and, if it is, set the
 *        value according to the display.
 */
bool bf::item_reference_edit::validate()
{
  return this->value_from_string( this->GetValue() );
} // item_reference_edit::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when the value has been changed, to update the display.
 */
void bf::item_reference_edit::value_updated()
{
  bool found = false;
  wxString val = this->value_to_string();
  unsigned int i=0;
  
  while ( (i!=this->GetCount()) && !found )
    if ( val == this->GetString(i) )
      found = true;
    else
      ++i;

  if ( found )
    this->SetSelection(i);
} // item_reference_edit::value_updated()
