/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/code/level_thumbnail_ctrl.cpp
 * \brief Implementation of the bf::level_thumbnail_ctrl class.
 * \author Julien Jorge
 */
#include "bf/level_thumbnail_ctrl.hpp"

#include <wx/dcbuffer.h>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param parent The window owning this one.
 */
bf::level_thumbnail_ctrl::level_thumbnail_ctrl( wxWindow* parent )
  : wxWindow(parent, wxID_ANY), m_level(NULL)
{

} // level_thumbnail_ctrl::level_thumbnail_ctrl()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the displayed level view.
 * \param view The level view to display.
 */
void bf::level_thumbnail_ctrl::set_view( const ingame_view_frame* view )
{
  m_level = view;

  if (m_level != NULL)
    {
      const ingame_view* v = m_level->get_ingame_view();
      const wxSize level_size
        ( v->get_level().get_width(), v->get_level().get_height() );
      const wxSize my_size( GetSize() );

      m_view_box.x = v->get_view_position().x * my_size.x / level_size.x;
      m_view_box.y = v->get_view_position().y * my_size.y / level_size.y;
      m_view_box.width = v->GetSize().x * my_size.x / level_size.x;
      m_view_box.height = v->GetSize().y * my_size.y / level_size.y;
    }

  Refresh();
} // level_thumbnail_ctrl::set_view()

/*----------------------------------------------------------------------------*/
/**
 * \brief Render the level.
 */
void bf::level_thumbnail_ctrl::render()
{
  wxBufferedPaintDC dc(this);

  if ( IsShown() )
    {
      dc.SetBackground(*wxBLACK_BRUSH);
      dc.Clear();

      if ( m_level != NULL )
        {
          dc.DrawBitmap
            ( m_level->get_ingame_view()->create_thumbnail( GetSize() ), 0, 0 );

          dc.SetPen(*wxRED_PEN);
          dc.SetBrush(*wxTRANSPARENT_BRUSH);

          dc.DrawRectangle(m_view_box);
        }
    }
} // level_thumbnail_ctrl::render()

/*----------------------------------------------------------------------------*/
/**
 * \brief Draw the content of the window.
 * \param event The paint event.
 */
void bf::level_thumbnail_ctrl::on_paint(wxPaintEvent& event)
{
  render();
} // level_thumbnail_ctrl::on_paint()

/*----------------------------------------------------------------------------*/
BEGIN_EVENT_TABLE(bf::level_thumbnail_ctrl, wxWindow)
  EVT_PAINT( bf::level_thumbnail_ctrl::on_paint )
END_EVENT_TABLE()
