/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/item_class_pool_frame.hpp
 * \brief The window showing the properties of an item.
 * \author Julien Jorge
 */
#ifndef __BF_ITEM_CLASS_POOL_FRAME_HPP__
#define __BF_ITEM_CLASS_POOL_FRAME_HPP__

#include <wx/wx.h>
#include <wx/treectrl.h>

#include <map>

#include "bf/tree_builder.hpp"
#include "bf/windows_layout.hpp"

namespace bf
{
  /**
   * \brief The frame displaying the available classes for the current layer.
   * \author Julien Jorge
   */
  class item_class_pool_frame:
    public wxFrame
  {
  public:
    item_class_pool_frame( wxFrame* parent );

    void set_layer( const wxString& layer_class );
    void set_window_layout( windows_layout& layout );

  private:
    wxTreeCtrl* add_tree();

    void create_tree();
    void create_categories_tree( tree_builder& tb ) const;

    void select_class(bool shift_down);

    void on_close(wxCloseEvent& event);
    void on_mouse_move(wxMouseEvent& event);
    void on_double_click(wxMouseEvent& event);
    void on_key_up(wxKeyEvent& event);

  private:
    /** \brief The tree. */
    wxTreeCtrl* m_tree;

    /** \brief The windows of the program. */
    windows_layout* m_windows_layout;

    DECLARE_EVENT_TABLE()

  }; // class item_class_pool_frame
} // namespace bf

#endif // __BF_ITEM_CLASS_POOL_FRAME_HPP__
