/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/level_file_xml_writer.hpp
 * \brief A class for writing source level files.
 * \author Julien Jorge
 */
#ifndef __BF_LEVEL_FILE_XML_WRITER_HPP__
#define __BF_LEVEL_FILE_XML_WRITER_HPP__

#include "bf/level.hpp"

#include <iostream>
#include <wx/xml/xml.h>

namespace bf
{
  /**
   * \brief A class for writing source level files.
   * \author Julien Jorge
   */
  class level_file_xml_writer
  {
  public:
    void save( std::ostream& f, const level& lvl ) const;

  private:
    void save_layer( std::ostream& os, const layer& the_layer ) const;
    void save_item( std::ostream& os, const item_instance& item ) const;
    void save_item_by_class
    ( std::ostream& os, const item_instance& item,
      const std::string& class_name ) const;

    void save_field
    ( std::ostream& os, const type_field& f, const item_instance& item ) const;

    void save_sprite
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item ) const;
    void save_animation
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item ) const;
    void save_sprite_list
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item ) const;
    void save_animation_list
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item ) const;

    void sprite_to_xml( std::ostream& os, const sprite& spr ) const;
    void animation_to_xml( std::ostream& os, const animation& spr ) const;

    template<typename Type>
    void value_to_xml
    ( std::ostream& os, const std::string& node_name, const Type& v ) const;

    template<typename Type>
    void save_value
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item, const std::string& node_name ) const;

    template<typename Type>
    void save_value_list
    ( std::ostream& os, const std::string& field_name,
      const item_instance& item, const std::string& node_name ) const;

  }; // class level_file_xml_writer
} // namespace bf

#include "bf/impl/level_file_xml_writer.tpp"

#endif // __BF_LEVEL_FILE_XML_WRITER_HPP__
