/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/properties_frame.hpp
 * \brief The window showing the properties of an item.
 * \author Julien Jorge
 */
#ifndef __BF_PROPERTIES_FRAME_HPP__
#define __BF_PROPERTIES_FRAME_HPP__

#include <wx/wx.h>
#include <wx/listctrl.h>

#include "bf/item_instance.hpp"
#include "bf/type_field.hpp"
#include "bf/windows_layout.hpp"

#include <vector>

namespace bf
{
  /**
   * \brief The properties window of our program.
   * \author Julien Jorge
   */
  class properties_frame:
    public wxFrame
  {
  public:
    /** \brief The identifiers of the controls. */
    enum control_id
      {
        IDC_ITEM_PROPERTIES,
        IDC_FIXED_STATE,
        IDC_TEXT_IDENTIFIER
      }; // enum control_id

  public:
    properties_frame( wxFrame* parent );

    void set_window_layout( windows_layout& layout );

    void set_item( item_instance* item );

  private:
    void enumerate_properties();
    void find_hierachy
    ( std::list<std::string>& hierarchy, const std::string& class_name ) const;
    void get_fields_of
    ( std::vector<std::string>& fields, const std::string& class_name ) const;
    void show_fields( const std::vector<std::string>& fields );

    void update_values();
    void set_required_color( unsigned int i, bool b );

    wxString convert_value_to_text( const type_field& f ) const;

    void adjust_last_column_size();

    void delete_selected_field();
    void create_field_editor( size_t index );
    void show_string_property_dialog( const type_field& f );
    void show_item_reference_property_dialog( const type_field& f );

    template<typename Type>
    void
    show_simple_property_dialog( const type_field& f, const wxString& type );

    template<typename Control>
    void show_property_dialog( const type_field& f, const wxString& type );

    template<typename Control, typename Type>
    void edit_field( const type_field& f, const wxString& type );

    template<typename Type>
    void edit_item_reference_field
    ( const type_field& f, const wxArrayString& values );

    template<typename DialogType>
    void show_dialog( const std::string& field_name, DialogType& dlg );

    template<typename Type>
    wxString convert_value_to_text( const std::string& field_name ) const;

    void update_controls();
    void create_controls();

    void on_close(wxCloseEvent& event);
    void on_size(wxSizeEvent& event);
    void on_column_begin_drag(wxListEvent& event);
    void on_column_end_drag(wxListEvent& event);
    void on_item_activated(wxListEvent& event);
    void on_change_fixed(wxCommandEvent& event);
    void on_key_up(wxKeyEvent& event);
    void on_validate_id(wxCommandEvent& event);

  private:
    /** \brief The item of which we modify the fields. */
    item_instance* m_item;

    /** \brief The list of properties available for this item. */
    wxListView* m_prop;

    /** \brief The control for configure the fixed option. */
    wxCheckBox* m_fixed_box;

    /** \brief The control in which we display the identifiant. */
    wxTextCtrl* m_id_text;

    /** \brief The windows of the program. */
    windows_layout* m_windows_layout;

    /** \brief The default title of the frame, when there's no item. */
    static wxString s_default_title;

    DECLARE_EVENT_TABLE()

  }; // class properties_frame
} // namespace bf

#include "bf/impl/properties_frame.tpp"

#endif // __BF_PROPERTIES_FRAME_HPP__
