/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file action.hpp
 * \brief An action for the model.
 * \author Julien Jorge
 */
#ifndef __MC_ACTION_HPP__
#define __MC_ACTION_HPP__

#include "mc/compiled_file.hpp"
#include "mc/animation_type.hpp"

namespace mc
{
  /**
   * \brief An action for the model.
   * \author Julien Jorge
   */
  class action
  {
  public:
    action();
    action( const std::string& name, const animation_type& anim,
            const std::string& sound_name );

    void output( compiled_file& f ) const;
    const std::string& get_name() const;

  private:
    /** \brief The name of the action. */
    std::string m_name;

    /** \brief The animation to play. */
    animation_type m_animation;

    /** \brief The name of the sound resource to use. */
    std::string m_sound_name;

  }; // class action
} // namespace mc

#endif // __MC_ACTION_HPP__
