/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file animation_type.hpp
 * \brief Animation type.
 * \author Julien Jorge
 */
#ifndef __MC_ANIMATION_TYPE__
#define __MC_ANIMATION_TYPE__

#include <list>

#include "mc/image_type.hpp"

namespace mc
{
  /**
   * \brief Animation type.
   * \author Julien Jorge
   */
  class animation_type
  {
  public:
    animation_type();
    animation_type( const std::list< image_type >& frames );

    void output( compiled_file& f ) const;

    void set_frames( const std::list< image_type >& frames );
    void set_flip_x( bool b );
    void set_flip_y( bool b );
    void set_alpha( float alpha );
    void set_loops( unsigned int loops );
    void set_loop_back( bool b );

  private:
    /** \brief The frames of the animation. */
    std::list< image_type > m_frames;

    /** \brief Flip the animation horizontaly. */
    bool m_flip_x;

    /** \brief Flip the animation verticaly. */
    bool m_flip_y;

    /** \brief Alpha transparency. */
    float m_alpha;

    /** \brief Number of loops. */
    unsigned int m_loops;

    /** \brief Play the animation backward. */
    bool m_loop_back;

  }; // class animation_type
} // namespace mc

#endif // __MC_ANIMATION_TYPE__
