/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file application.hpp
 * \brief The main class.
 * \author Julien Jorge
 */
#ifndef __MC_APPLICATION_HPP__
#define __MC_APPLICATION_HPP__

#include <claw/application.hpp>
#include <list>

namespace mc
{
  /**
   * \brief The main class.
   *
   * The program accept the following parameters :
   * - --xml Output the tree as XML,
   * - --help Print help and exit.
   * \author Julien Jorge
   */
  class application : public claw::application
  {
  public:
    application( int& argc, char** &argv );

    int run();

  private:
    void help() const;
    void check_arguments( int& argc, char** &argv );
    void store_files( int& argc, char** &argv );

    void compile_file( const std::string& filename ) const;
    void get_output_name( const std::string& filename,
                          std::string& output_name ) const;

  private:
    /** \brief The files to compile. */
    std::list<std::string> m_files;

    /** \brief Tell if we have to output the tree as XML. */
    bool m_xml;

    /** \brief Tell if we should quit immediatly. */
    bool m_quit;

  }; // class application
} // namespace mc

#endif // __MC_APPLICATION_HPP__
