/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file action.cpp
 * \brief Implementation of the mc::action class.
 * \author Julien Jorge
 */
#include "mc/action.hpp"
#include "model_code_value.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Default constructor.
 */
mc::action::action()
{

} // action::action()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param name The name of the action.
 * \param anim The animation to play.
 * \param sound_name The sound to play.
 */
mc::action::action( const std::string& name, const animation_type& anim,
                    const std::string& sound_name )
  : m_name(name), m_animation(anim), m_sound_name(sound_name)
{

} // action::action()

/*----------------------------------------------------------------------------*/
/**
 * \brief Write the action in the compiled file.
 * \param f The file to write in.
 */
void mc::action::output( compiled_file& f ) const
{
  f << bear::model_code_value::action << m_name;
  m_animation.output(f);
  f << m_sound_name;
} // action::output()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the name of the action.
 */
const std::string& mc::action::get_name() const
{
  return m_name;
} // action::get_name()
