/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file custom_type.hpp
 * \brief Base class for simple types (integer, real, bool and string).
 * \author Julien Jorge
 */
#ifndef __MC_CUSTOM_TYPE__
#define __MC_CUSTOM_TYPE__

#include "mc/compiled_file.hpp"

namespace mc
{
  /**
   * \brief Base class for simple types (integer, real, bool and string).
   * \author Julien Jorge
   */
  template< class Type >
  class custom_type
  {
  public:
    void set_value( const Type& value );
    const Type& get_value() const;

    void output( compiled_file& f ) const;

  private:
    /** \brief The current value of the variable. */
    Type m_value;
  }; // class custom_type

  /** \brief Integer type. */
  typedef
  custom_type< unsigned int > u_integer_type;

  /** \brief Real type. */
  typedef
  custom_type< float > real_type;

  /** \brief String type. */
  typedef
  custom_type< std::string > string_type;

  /** \brief Boolean type. */
  typedef
  custom_type< bool > bool_type;
} // namespace mc

#include "mc/code/custom_type.tpp"

#endif // __MC_CUSTOM_TYPE__
