/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file model.hpp
 * \brief The model described in the file.
 * \author Julien Jorge
 */
#ifndef __MC_MODEL_HPP__
#define __MC_MODEL_HPP__

#include <map>
#include <list>

#include "mc/gfx.hpp"
#include "mc/sound.hpp"
#include "mc/action.hpp"

namespace mc
{
  /**
   * \brief The model described in the file.
   */
  class model
  {
  public:
    void output( compiled_file& f ) const;

    void add_image_resource( const std::string& name, const gfx& value );
    void add_sound_resource( const std::string& name, const sound& value );
    void add_action( const action& value );

    bool has_image_resource( const std::string& name ) const;
    bool has_sound_resource( const std::string& name ) const;
    bool has_action( const std::string& name ) const;

    const gfx& get_image_resource( const std::string& name ) const;
    sound get_sound_resource( const std::string& name ) const;

  private:
    void output_actions( compiled_file& f ) const;

  private:
    /** \brief Graphic resources of the model. */
    std::map<std::string, gfx> m_image_resources;

    /** \brief Sound resources of the model. */
    std::map<std::string, sound> m_sound_resources;

    /** \brief The actions of the model. */
    std::map<std::string, action> m_actions;

  }; // class model
} // namespace mc

#endif // __MC_MODEL_HPP__
