/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file model_compiler.hpp
 * \brief The model file compiler.
 * \author Julien Jorge
 */
#ifndef __MC_MODEL_COMPILER_HPP__
#define __MC_MODEL_COMPILER_HPP__

#include <boost/spirit.hpp>
#include <boost/spirit/iterator/position_iterator.hpp>
#include <boost/spirit/tree/parse_tree.hpp>

#include "mc/compiled_file.hpp"

namespace mc
{
  /**
   * \brief The model file compiler.
   */
  class model_compiler
  {
  public:
    typedef boost::spirit::position_iterator<const char*>     iterator;
    typedef boost::spirit::node_iter_data_factory<iterator>   node_factory;
    typedef boost::spirit::tree_match<iterator, node_factory> tree_match;
    typedef tree_match::node_t                                tree_node;

  private:
    typedef boost::spirit::scanner<iterator> scanner;

  public:

  public:
    bool run( compiled_file& f, const std::string& in_file,
              bool xml = false );
    bool run( compiled_file& f, const char* file_data,
              unsigned int file_size, const std::string& file_name,
              bool xml = false );

  private:
    void scan_tree( compiled_file& f, const tree_node& node );

    void xml_output( const tree_match::container_t& trees ) const;

    bool file_exists( const std::string& filename ) const;
  }; // class model_compiler
} // namespace mc

#endif // __MC_MODEL_COMPILER_HPP__
