/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_resources_part.cpp
 * \brief Implementation of the mc::node_compiler_resource class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_resource.hpp"

#include <claw/assert.hpp>
#include "mc/model_grammar.hpp"
#include "mc/node_compiler/node_compiler_resource_image.hpp"
#include "mc/node_compiler/node_compiler_resource_sound.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node containing a resource.
 * \param the_model The model we are compiling.
 * \param node Node to compile.
 */
void mc::node_compiler_resource::compile_node
( model& the_model, const tree_node& node ) const
{
  CLAW_PRECOND( node.value.id() == model_grammar::id_resource );

  node_compiler_resource_image comp_image;
  node_compiler_resource_sound comp_sound;

  if ( node.children[0].value.id() == model_grammar::id_resource_image )
    comp_image.compile_node( the_model, node.children[0] );
  else
    comp_sound.compile_node( the_model, node.children[0] );
} // node_compiler_resource::compile_node()
