/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file export.hpp
 * \brief Macros and function useful for class exportation.
 * \author Julien Jorge
 */
#ifndef __PTB_EXPORT_HPP__
#define __PTB_EXPORT_HPP__

#include "engine/layer/gui_layer.hpp"
#include "engine/export.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Export a layer class.
 *
 * \param layer_class_name The name of the class to instanciate.
 * \param env The full namespace of this class.
 *
 * The instance is created with the <tt>new</tt> operator.
 *
 * The signature of the function declared by this macro is
 *
 *   <tt>bear::engine::gui_layer* create_gui_layer_<i>class_name</i>()</tt>
 */
#define GUI_LAYER_EXPORT( layer_class_name, env )                       \
  extern "C"                                                            \
  bear::engine::gui_layer* DLL_EXPORT create_gui_layer_ ## layer_class_name() \
  {                                                                     \
    return new env::layer_class_name;                                   \
  }

/*----------------------------------------------------------------------------*/
namespace ptb
{
  /**
   * \brief Get the name of the exported function made for a layer class.
   * \param class_name The name of the class that has been exported.
   */
  inline std::string
  gui_layer_export_function_name( const std::string& class_name )
  {
    // prefix must be the string used for prefix in GUI_LAYER_EXPORT
    return "create_gui_layer_" + class_name;
  } // gui_layer_export_function_name()

  typedef bear::engine::gui_layer* (*gui_layer_export_function_type)();

} // namespace ptb

#endif // __PTB_EXPORT_HPP__

