/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_configure.cpp
 * \brief Implementation of the ptb::frame_configure class.
 * \author Julien Jorge
 */
#include "ptb/frame/frame_configure.hpp"
#include "ptb/frame/frame_language.hpp"
#include "ptb/frame/frame_player_controls.hpp"
#include "ptb/frame/frame_screen.hpp"
#include "ptb/frame/message_box.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::frame_configure::frame_configure( windows_layer* owning_layer, 
                                       bool language_option )
  : menu_frame(owning_layer), m_language_option(language_option)
{
  create_controls();
} // frame_configure::frame_configure()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::frame_configure::validate() const
{
  unsigned int pos = get_menu().cursor_position();

  if ( pos == m_pos_first_player_controls )
    show_window( new frame_player_controls(m_owning_layer, 1) );
  else if ( pos == m_pos_second_player_controls )
    show_window( new frame_player_controls(m_owning_layer, 2) );
  else if ( pos == m_pos_screen ) 
    show_window( new frame_screen(m_owning_layer) ); 
  else if ( pos == m_pos_language )
    show_window( new frame_language(m_owning_layer) );
  else if ( pos == m_pos_back )
    close_window();
  else // if ( pos == m_pos_audio ) || ( pos == m_pos_password ) 
    show_window( new message_box(m_owning_layer, "not_available") );
} // frame_configure::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the static text components.
 */
void ptb::frame_configure::create_controls()
{
  m_pos_first_player_controls = 0;
  m_pos_second_player_controls = 1;
  m_pos_screen = 2;
  m_pos_audio = 3;
  m_pos_password = 4;

  if ( m_language_option ) 
    {
      char* strings[] = 
        { "first_player_controls", "second_player_controls",
          "screen", "audio", "password", "language", "back", NULL };
      get_menu().make( strings );

      m_pos_language = 5;
      m_pos_back = 6;
    }
  else
    {
      char* strings[] = 
        { "first_player_controls", "second_player_controls",
          "screen", "audio", "password", "back", NULL };
      get_menu().make( strings );

      m_pos_back = 5;
      m_pos_language = 6;
    }
  
  set_size( get_menu().get_size() );
} // frame_configure::create_controls()
