/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file menu.cpp
 * \brief Implementation of the ptb::menu class.
 * \author Julien Jorge
 */
#include "ptb/frame/menu.hpp"

#include "engine/font_factory.hpp"
#include "engine/game.hpp"
#include "engine/string_base.hpp"
#include "ptb/frame/frame.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owner The component owning this menu.
 * \param horizontal_margins The size of the margins on the left and on the
 *        right.
 * \param vertical_margins The size of the margins at the top and at the bottom.
 */
ptb::menu::menu
( bear::gui::visual_component* owner, unsigned int horizontal_margins,
  unsigned int vertical_margins, unsigned int line_space )
  : bear::gui::menu( owner, frame::get_cursor(),
                     bear::engine::font_factory::create
                     ("font/fixed_yellow-10x20.png"),
                     horizontal_margins, vertical_margins, line_space )
{
  set_size( bear::engine::game::get_instance().get_screen_size() );
} // menu::menu()

/*----------------------------------------------------------------------------*/
/**
 * \brief Add items from a list of strings and call auto_size().
 * \param strings The names of the strings to add, from the language file.
 * \pre The last item in strings is NULL.
 */
void ptb::menu::make( char* strings[] )
{
  for (unsigned int i=0; strings[i]!=NULL; ++i)
    {
      std::string text(strings[i]);
      bear::engine::string_base::get_instance().get_string(text);

      bear::gui::static_text& static_text = add();

      static_text.set_auto_size(true);
      static_text.set_text( text );
    }

  auto_size();
} // menu::make()
